/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromPaymentList;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromPaymentListUI
extends CreateFromPaymentList
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int Org_ID;
    private int BPartner_ID;
    private CLabel documentNoLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    protected CTextField documentNoField = new CTextField(10);
    protected CLabel BPartner_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    protected VLookup bPartnerLookup;
    protected CLabel Org_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
    protected VLookup OrgLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private boolean m_actionActive = false;

    public VCreateFromPaymentListUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow((Window)Env.getWindow((int)this.p_WindowNo), (Window)((Object)this.dialog));
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle("Listado de  Pagos");
        CButton refreshButton = ConfirmPanel.createRefreshButton((boolean)false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener((ActionListener)this);
        this.dialog.getConfirmPanel().addButton((JButton)refreshButton);
        this.dialog.getRootPane().setDefaultButton((JButton)refreshButton);
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30));
        this.BPartner_idLabel.setLabelFor((Component)this.bPartnerLookup);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateTrx");
        this.dateToField.setValue((Object)date);
        this.OrgLookup = new VLookup("AD_Org_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_PaymentRequest", (String)"AD_Org_ID"), (int)30));
        this.Org_idLabel.setLabelFor((Component)this.OrgLookup);
        this.Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"AD_Org_ID");
        this.OrgLookup.setValue((Object)this.Org_ID);
        this.loadLines();
        return true;
    }

    private void jbInit() throws Exception {
        this.documentNoLabel.setLabelFor((Component)this.documentNoField);
        this.dateFromLabel.setLabelFor((Component)this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToLabel.setLabelFor((Component)this.dateToField);
        this.dateToField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout((LayoutManager)new BorderLayout());
        CPanel parameterBankPanel = new CPanel();
        parameterBankPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)parameterBankPanel, (Object)"Center");
        parameterBankPanel.add((Component)this.BPartner_idLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerLookup != null) {
            parameterBankPanel.add((Component)this.bPartnerLookup, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.Org_idLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.OrgLookup != null) {
            parameterBankPanel.add((Component)this.OrgLookup, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateFromLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.dateFromField != null) {
            parameterBankPanel.add((Component)this.dateFromField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateToLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.dateToField != null) {
            parameterBankPanel.add((Component)this.dateToField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.documentNoLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.documentNoField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            this.loadLines();
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
        this.m_actionActive = false;
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
    }

    private void loadLines() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("");
        sql.append(" select i.c_payment_id,i.documentno,i.datetrx,i.c_bpartner_id,bp.name,i.payamt, i.description from c_payment i inner join c_bpartner bp on (i.c_bpartner_id=bp.c_bpartner_id)  where i.isreceipt='N' and i.docstatus in ('DR') and i.payamt>0 ");
        if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
            sql.append(" And i.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
        }
        if (this.OrgLookup.getValue() != null && (Integer)this.OrgLookup.getValue() > 0) {
            sql.append(" And i.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
        }
        if (this.documentNoField.getText().length() > 0) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
        }
        if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
            Timestamp from = (Timestamp)this.dateFromField.getValue();
            Timestamp to = (Timestamp)this.dateToField.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(i.datetrx) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(i.datetrx) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.datetrx) BETWEEN ? AND ?");
            }
        }
        this.log.config("**" + sql);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            int index = 1;
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                Timestamp from = (Timestamp)this.dateFromField.getValue();
                Timestamp to = (Timestamp)this.dateToField.getValue();
                this.log.fine("Date From=" + from + ", To=" + to);
                if (from == null && to != null) {
                    pstmt.setTimestamp(index++, to);
                } else if (from != null && to == null) {
                    pstmt.setTimestamp(index++, from);
                } else if (from != null && to != null) {
                    pstmt.setTimestamp(index++, from);
                    pstmt.setTimestamp(index++, to);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(10);
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(4), rs.getString(5));
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(3));
                line.add(pp2);
                line.add(pp);
                line.add(rs.getBigDecimal(6));
                line.add(rs.getString(7));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.loadTableOIS(data);
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        this.dialog.tableChanged(null);
    }
}

