/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.grid.CreateFrom;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisitionLine;
import org.compiere.swing.CPanel;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCreateFromOrder
extends CreateFrom
implements ActionListener,
VetoableChangeListener {
    private int Order_ID;
    private int Org_ID;
    private int AD_UserID = 0;
    private int SubProject_ID = 0;
    private int p_WindowNo;
    private VLookup userSearch;
    private VLookup SpjSearch;
    private GridTab p_mTab;
    private VCreateFromDialog dialog;
    private JLabel userLabel;
    private JLabel spjLabel;

    VCreateFromOrder(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
        this.log.info("");
        this.p_WindowNo = this.getGridTab().getWindowNo();
        this.p_mTab = mTab;
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        AEnv.positionCenterWindow((Window)Env.getWindow((int)this.p_WindowNo), (Window)((Object)this.dialog));
    }

    private void jbInit() throws Exception {
        this.userLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"AD_User_ID"));
        this.spjLabel.setText("Proyecto");
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout((LayoutManager)new BorderLayout());
        CPanel parameterStdPanel = new CPanel((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, (Object)"Center");
        parameterStdPanel.add((Component)this.userLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.userSearch, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.spjLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.SpjSearch, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public boolean dynInit() throws Exception {
        if (this.p_mTab.getValue("C_Order_ID") == null) {
            return false;
        }
        this.setTitle("Requisitions Lines");
        int AD_Column_ID = MColumn.getColumn_ID((String)"M_Requisition", (String)"AD_User_ID");
        MLookup lookupUser = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)AD_Column_ID, (int)30);
        this.userSearch = new VLookup("AD_User_ID", true, false, true, (Lookup)lookupUser);
        this.userSearch.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"M_Requisition", (String)"C_SubProjectOFB_ID");
        MLookup lookupSpj = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)AD_Column_ID, (int)30);
        this.SpjSearch = new VLookup("C_SubProjectOFB_ID", true, false, true, (Lookup)lookupSpj);
        this.SpjSearch.addVetoableChangeListener((VetoableChangeListener)this);
        this.Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_Order_ID");
        this.Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"AD_Org_ID");
        this.loadLines(0, 0);
        return true;
    }

    protected void initBPDetails(int C_BPartner_ID) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName() == "AD_User_ID") {
            if (e.getNewValue() != null) {
                this.AD_UserID = (Integer)e.getNewValue();
                this.loadLines(this.AD_UserID, this.SubProject_ID);
            }
        } else if (e.getPropertyName() == "C_SubProjectOFB_ID" && e.getNewValue() != null) {
            this.SubProject_ID = (Integer)e.getNewValue();
            this.loadLines(this.AD_UserID, this.SubProject_ID);
        }
        this.dialog.tableChanged(null);
    }

    private void loadLines(int AD_User, int SubPro) {
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx"));
        int bPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        Vector data = new Vector();
        String sql = "";
        sql = DB.isPostgreSQL() ? "Select A.DocumentNo,A.DATEREQUIRED,A.AD_USER_ID,A.M_Requisition_ID,C.M_PRODUCT_ID,(C.QTY-coalesce(C.QtyUsed,0)),C.M_Requisitionline_id,B.name, P.name as Productname,C.PRICEACTUAL,C.C_SubProjectOFB_ID,pj.name as Projectname,C.description, C.IsRfQ  from M_Requisition A  inner join M_RequisitionLine C on (A.M_Requisition_ID=C.M_Requisition_ID) inner join M_Product P on (P.M_Product_ID=C.M_Product_ID) inner join C_DocType doc on (A.C_DocType_ID=doc.C_DocType_ID) left outer join AD_User B on (A.AD_USER_ID=B.AD_USER_ID) left outer join C_SubProjectOFB pj on (C.C_SubProjectOFB_ID=pj.C_SubProjectOFB_ID) where A.DocStatus='CO' and A.isactive='Y' and C.isactive='Y' and  doc.docbasetype not in ('RRC','PLR','PRT')  and A.AD_Org_ID=" + this.Org_ID : "Select A.DocumentNo,A.DATEREQUIRED,A.AD_USER_ID,A.M_Requisition_ID,C.M_PRODUCT_ID,(C.QTY-coalesce(C.QtyUsed,0)),C.M_Requisitionline_id,B.name, P.name as Productname,C.PRICEACTUAL,C.C_SubProjectOFB_ID,pj.name as Projectname,C.description, C.IsRfQ  from M_Requisition A  inner join M_RequisitionLine C on (A.M_Requisition_ID=C.M_Requisition_ID) inner join M_Product P on (P.M_Product_ID=C.M_Product_ID) inner join C_DocType doc on (A.C_DocType_ID=doc.C_DocType_ID) left outer join AD_User B on (A.AD_USER_ID=B.AD_USER_ID) left outer join C_SubProjectOFB pj on (C.C_SubProjectOFB_ID=pj.C_SubProjectOFB_ID) where A.DocStatus='CO' and A.isactive='Y' and C.isactive='Y' and doc.docbasetype not in ('RRC','PLR','PRT') and A.AD_Org_ID=" + this.Org_ID;
        sql = !IsSOTrx ? String.valueOf(sql) + " and not EXISTS (select * from C_OrderLine ol where ol.M_Requisitionline_id=C.M_Requisitionline_id) " : String.valueOf(sql) + " and (C.QTY-coalesce(C.QtyUsed,0)) > 0";
        sql = IsSOTrx ? String.valueOf(sql) + " and doc.issotrx='Y' and A.C_BPartner_ID=" + bPartner_ID : String.valueOf(sql) + " and doc.issotrx='N'";
        if (AD_User > 0) {
            sql = String.valueOf(sql) + " and A.AD_User_ID=" + AD_User;
        }
        if (SubPro > 0) {
            sql = String.valueOf(sql) + " and pj.C_SubProjectOFB_ID=" + SubPro;
        }
        this.log.config("**" + sql);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("IsRfQ").equals("Y")) continue;
                Vector<Object> line = new Vector<Object>(10);
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(2));
                line.add(rs.getString(8));
                line.add(rs.getString(1));
                line.add(rs.getString(12));
                line.add(rs.getString(9));
                line.add(rs.getString(13));
                line.add(rs.getBigDecimal(6));
                line.add(rs.getBigDecimal(10));
                line.add(rs.getInt(5));
                line.add(rs.getInt(7));
                line.add(rs.getInt(11));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DateRequired"));
        columnNames.add("Usuario");
        columnNames.add("N\u00ef\u00bf\u00bd Solicitud");
        columnNames.add("Proyecto/OT");
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"ProductName"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Price"));
        columnNames.add("Control");
        columnNames.add("Seguimiento");
        columnNames.add("Traza");
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.dialog.getMiniTable().setColumnClass(0, Boolean.class, false);
        this.dialog.getMiniTable().setColumnClass(1, Timestamp.class, true);
        this.dialog.getMiniTable().setColumnClass(2, String.class, true);
        this.dialog.getMiniTable().setColumnClass(3, String.class, true);
        this.dialog.getMiniTable().setColumnClass(4, String.class, true);
        this.dialog.getMiniTable().setColumnClass(5, String.class, true);
        this.dialog.getMiniTable().setColumnClass(6, String.class, true);
        this.dialog.getMiniTable().setColumnClass(7, BigDecimal.class, true);
        this.dialog.getMiniTable().setColumnClass(8, BigDecimal.class, true);
        this.dialog.getMiniTable().setColumnClass(9, Integer.class, true);
        this.dialog.getMiniTable().setColumnClass(10, Integer.class, true);
        this.dialog.getMiniTable().setColumnClass(11, Integer.class, true);
        this.dialog.getMiniTable().autoSize();
    }

    @Override
    public void info() {
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        MOrder newOrder = new MOrder(Env.getCtx(), this.Order_ID, null);
        this.log.config("**doctype " + newOrder.getC_DocTypeTarget_ID());
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MOrderLine line = new MOrderLine(newOrder);
                BigDecimal valor = (BigDecimal)miniTable.getValueAt(i, 8);
                this.log.config("valor:" + valor);
                line.setPrice(valor);
                Integer product = (Integer)miniTable.getValueAt(i, 9);
                line.setProduct(new MProduct(Env.getCtx(), product, null));
                line.setQtyOrdered((BigDecimal)miniTable.getValueAt(i, 7));
                line.setQtyEntered((BigDecimal)miniTable.getValueAt(i, 7));
                Integer subproject = (Integer)miniTable.getValueAt(i, 11);
                line.set_ValueOfColumn("C_SubProjectOFB_ID", (int)subproject);
                Integer requiline = (Integer)miniTable.getValueAt(i, 10);
                line.set_ValueOfColumn("M_RequisitionLine_ID", (int)requiline);
                line.setDescription((String)miniTable.getValueAt(i, 6));
                line.setAD_Org_ID(new MRequisitionLine(Env.getCtx(), requiline, null).getAD_Org_ID());
                boolean OK = line.save();
                if (OK) {
                    DB.executeUpdate((String)("update M_RequisitionLine set C_ORDERLINE_ID=" + line.getC_OrderLine_ID() + " where M_RequisitionLine_ID=" + (Integer)miniTable.getValueAt(i, 10)));
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
    }
}

