/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromInternalUse;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromInternalUseUI
extends CreateFromInternalUse
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int Org_ID;
    private int BPartner_ID;
    private CLabel documentNoLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    protected CTextField documentNoField = new CTextField(10);
    protected CLabel BPartner_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    protected VLookup bPartnerLookup;
    protected CLabel Org_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
    protected VLookup OrgLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"MovementDate"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private boolean m_actionActive = false;

    public VCreateFromInternalUseUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow((Window)Env.getWindow((int)this.p_WindowNo), (Window)((Object)this.dialog));
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle("Solicitud desde");
        CButton refreshButton = ConfirmPanel.createRefreshButton((boolean)false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener((ActionListener)this);
        this.dialog.getConfirmPanel().addButton((JButton)refreshButton);
        this.dialog.getRootPane().setDefaultButton((JButton)refreshButton);
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30));
        this.BPartner_idLabel.setLabelFor((Component)this.bPartnerLookup);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"MovementDate");
        this.dateFromField.setValue((Object)date);
        this.dateToField.setValue((Object)date);
        this.OrgLookup = new VLookup("AD_Org_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"M_Inventory", (String)"AD_Org_ID"), (int)30));
        this.Org_idLabel.setLabelFor((Component)this.OrgLookup);
        this.loadLines();
        return true;
    }

    private void jbInit() throws Exception {
        this.documentNoLabel.setLabelFor((Component)this.documentNoField);
        this.dateFromLabel.setLabelFor((Component)this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToLabel.setLabelFor((Component)this.dateToField);
        this.dateToField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout((LayoutManager)new BorderLayout());
        CPanel parameterBankPanel = new CPanel();
        parameterBankPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)parameterBankPanel, (Object)"Center");
        parameterBankPanel.add((Component)this.BPartner_idLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerLookup != null) {
            parameterBankPanel.add((Component)this.bPartnerLookup, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.Org_idLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.OrgLookup != null) {
            parameterBankPanel.add((Component)this.OrgLookup, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateFromLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.dateFromField != null) {
            parameterBankPanel.add((Component)this.dateFromField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateToLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.dateToField != null) {
            parameterBankPanel.add((Component)this.dateToField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.documentNoLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.documentNoField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            this.loadLines();
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
        this.m_actionActive = false;
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
    }

    private void loadLines() {
        Timestamp to;
        Timestamp from;
        Vector data = new Vector();
        String type = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"TypeInventory");
        type = this.getGridTab().get_ValueAsString("TypeInventory");
        type = Character.toString(type.charAt(0));
        StringBuffer sql = new StringBuffer("");
        if (type.equals("R")) {
            sql.append("select mil.m_inoutline_id, mio.documentno, mio.movementdate, mio.c_bpartner_id, bp.name, mil.m_product_id, mp.name, mil.qtyentered, mil.description,cdt.name, mil.M_locator_id, ml.value, mil.M_AttributeSetInstance_ID from M_InOutLine mil inner join M_InOut mio on (mil.M_InOut_ID = mio.M_InOut_ID) inner join C_BPartner bp on (mio.c_bpartner_id=bp.c_bpartner_id) inner join C_Doctype cdt on (mio.C_Doctype_ID = cdt.C_Doctype_ID) left join M_Product mp on (mil.M_Product_ID = mp.M_Product_ID) left join M_Locator ml on (mil.M_Locator_ID = ml.M_Locator_ID) where mio.issotrx='N' and mio.docstatus in ('CO','CL') and mil.m_product_id > 0 and mio.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And mio.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null && (Integer)this.OrgLookup.getValue() > 0) {
                sql.append(" And mio.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(mio.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(mio.movementdate) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(mio.movementdate) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(mio.movementdate) BETWEEN ? AND ?");
                }
            }
            sql.append(" And mil.m_inoutline_id Not IN (select ml.m_inoutline_id from M_Inventoryline ml inner join M_Inventory mi on (ml.M_Inventory_id=mi.M_Inventory_id) where mi.docstatus IN ('DR','CL','WC','CO')and m_inoutline_id is not null ) ");
        } else if (type.equals("O")) {
            sql.append("select otr.MP_OT_Resource_id, ot.documentno, ot.datetrx, 0, ' ', otr.m_product_id, mp.name, otr.resourceqty, ot.description, cdt.name, mp.M_locator_id, ml.value, 0 from MP_OT ot inner join MP_OT_Task ott on (ot.MP_OT_ID = ott.MP_OT_ID) inner join MP_OT_Resource otr on (ott.MP_OT_Task_ID = otr.MP_OT_Task_ID) inner join C_Doctype cdt on (ot.C_Doctype_ID = cdt.C_Doctype_ID) left join M_Product mp on (otr.M_Product_ID = mp.M_Product_ID) left join M_Locator ml on (mp.M_Locator_ID = ml.M_Locator_ID) where ot.docstatus in ('DR') and otr.m_product_id > 0 and ot.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (this.OrgLookup.getValue() != null) {
                sql.append(" And ot.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(ot.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(ot.datetrx) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(ot.datetrx) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(ot.datetrx) BETWEEN ? AND ?");
                }
            }
            sql.append(" And otr.MP_OT_Resource_id Not IN  (select ml.MP_OT_Resource_id from M_Inventoryline ml inner join M_Inventory mi on (ml.M_Inventory_id=mi.M_Inventory_id) where mi.docstatus IN ('DR','CL','WC','CO')and ml.MP_OT_Resource_id is not null )");
        } else {
            sql.append("select mil.m_inoutline_id, mio.documentno, mio.movementdate, mio.c_bpartner_id, bp.name, mil.m_product_id, mp.name, mil.qtyentered, mil.description,cdt.name, mil.M_locator_id, ml.value, mil.M_AttributeSetInstance_ID from M_InOutLine mil inner join M_InOut mio on (mil.M_InOut_ID = mio.M_InOut_ID) inner join C_BPartner bp on (mio.c_bpartner_id=bp.c_bpartner_id) inner join C_Doctype cdt on (mio.C_Doctype_ID = cdt.C_Doctype_ID) left join M_Product mp on (mil.M_Product_ID = mp.M_Product_ID) left join M_Locator ml on (mil.M_Locator_ID = ml.M_Locator_ID) where mio.issotrx='N' and mio.docstatus in ('CO','CL') and mil.m_product_id > 0 and mio.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And mio.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null && (Integer)this.OrgLookup.getValue() > 0) {
                sql.append(" And mio.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(mio.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(mio.movementdate) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(mio.movementdate) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(mio.movementdate) BETWEEN ? AND ?");
                }
            }
            sql.append(" And mil.m_inoutline_id Not IN (select ml.m_inoutline_id from M_Inventoryline ml inner join M_Inventory mi on (ml.M_Inventory_id=mi.M_Inventory_id) where mi.docstatus IN ('DR','CL','WC','CO')and m_inoutline_id is not null ) ");
        }
        this.log.config("**" + sql);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            int index = 1;
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                Timestamp from2 = (Timestamp)this.dateFromField.getValue();
                Timestamp to2 = (Timestamp)this.dateToField.getValue();
                this.log.fine("Date From=" + from2 + ", To=" + to2);
                if (from2 == null && to2 != null) {
                    pstmt.setTimestamp(index++, to2);
                } else if (from2 != null && to2 == null) {
                    pstmt.setTimestamp(index++, from2);
                } else if (from2 != null && to2 != null) {
                    pstmt.setTimestamp(index++, from2);
                    pstmt.setTimestamp(index++, to2);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if ((type.equals("R") || type.equals("O")) && rs.getBigDecimal(8).signum() == 0) continue;
                Vector<Object> line = new Vector<Object>(10);
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                KeyNamePair pproduct = new KeyNamePair(rs.getInt(6), rs.getString(7));
                KeyNamePair ploc = new KeyNamePair(rs.getInt(11), rs.getString(12));
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(3));
                if (rs.getInt(4) < 1 || rs.getString(5) == null) {
                    line.add(0);
                } else {
                    KeyNamePair pp2 = new KeyNamePair(rs.getInt(4), rs.getString(5));
                    line.add(pp2);
                }
                line.add(pp);
                line.add(rs.getString(10));
                line.add(pproduct);
                line.add(rs.getBigDecimal(8));
                line.add(rs.getString(9));
                if (rs.getInt(11) > 0 || rs.getString(12) == null) {
                    line.add(ploc);
                } else {
                    line.add(0);
                }
                if (rs.getInt(13) > 0) {
                    line.add(rs.getInt(13));
                } else {
                    line.add(0);
                }
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.loadTableOIS(data);
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        this.dialog.tableChanged(null);
    }
}

