/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInventoryLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromInternalUse
extends CreateFrom {
    public CreateFromInternalUse(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, BigDecimal.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, Integer.TYPE, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int header_ID = (Integer)this.getGridTab().getValue("M_Inventory_ID");
        String type = this.getGridTab().get_ValueAsString("TypeInventory");
        type = Character.toString(type.charAt(0));
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, trxName);
                KeyNamePair document = (KeyNamePair)miniTable.getValueAt(i, 3);
                KeyNamePair prod = (KeyNamePair)miniTable.getValueAt(i, 5);
                KeyNamePair loc = (KeyNamePair)miniTable.getValueAt(i, 8);
                int atr = (Integer)miniTable.getValueAt(i, 9);
                String desc = (String)miniTable.getValueAt(i, 7);
                BigDecimal qty = (BigDecimal)miniTable.getValueAt(i, 6);
                String sql = "SELECT MAX(C_Charge_ID) FROM c_charge where tipocargo = 'TC12'";
                int chargeID = DB.getSQLValue(null, (String)sql);
                line.setM_Inventory_ID(header_ID);
                if (loc.getKey() > 0) {
                    line.setM_Locator_ID(loc.getKey());
                }
                line.setM_Product_ID(prod.getKey());
                if (atr > 0) {
                    line.setM_AttributeSetInstance_ID(atr);
                }
                line.setDescription(desc);
                line.setQtyInternalUse(qty);
                line.setC_Charge_ID(chargeID);
                if (type.equals("R")) {
                    line.set_CustomColumn("M_InOutLIne_ID", document.getKey());
                }
                if (type.equals("O")) {
                    line.set_CustomColumn("MP_OT_Resource_ID", document.getKey());
                }
                line.save();
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DateTrx"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DocumentNo"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DocumentType"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Producto"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Locator"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AttributeSetInstance"));
        return columnNames;
    }
}

