/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.apps.search.VScheduleTimePanel;
import org.compiere.grid.ed.VAssignmentDialog;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.plaf.CompiereUtils;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.TimeUtil;

public class VSchedulePanel
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = -7779310781236274016L;
    private int m_noDays = 1;
    private int m_height = 250;
    private int m_dayWidth = 170;
    private VScheduleTimePanel m_timePanel = null;
    private MAssignmentSlot[] m_slots = null;
    private Rectangle[] m_where = null;
    private Timestamp m_startDate = null;
    private boolean m_createNew = false;
    private int m_S_Resource_ID = 0;
    private InfoSchedule m_infoSchedule = null;
    private static final int MARGIN = 2;
    private static CLogger log = CLogger.getCLogger(VSchedulePanel.class);

    public VSchedulePanel() {
        this.setHeight(250);
        this.addMouseListener(this);
    }

    public void setType(int type) {
        this.m_noDays = type == 2 ? 31 : (type == 3 ? 7 : 1);
        this.setSize();
    }

    public void setInfoSchedule(InfoSchedule is) {
        this.m_infoSchedule = is;
    }

    public void setCreateNew(boolean createNew) {
        this.m_createNew = createNew;
    }

    public void setHeight(int height) {
        this.m_height = height;
        this.setSize();
    }

    public void setSize() {
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        if (g == null) {
            g = Env.getGraphics((Container)this);
        }
        if (g != null) {
            fm = g.getFontMetrics(g.getFont());
        }
        this.m_dayWidth = 0;
        int i = 0;
        while (i < this.m_noDays) {
            String string;
            int width;
            if (fm != null && (width = fm.stringWidth(string = this.getHeading(i))) > this.m_dayWidth) {
                this.m_dayWidth = width;
            }
            ++i;
        }
        this.m_dayWidth += 20;
        if (this.m_dayWidth < 180) {
            this.m_dayWidth = 180;
        }
        int w = this.m_noDays * this.m_dayWidth;
        Dimension size = new Dimension(w, this.m_height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    public void setTimePanel(VScheduleTimePanel timePanel) {
        this.m_timePanel = timePanel;
    }

    public void setAssignmentSlots(MAssignmentSlot[] mass, int S_Resource_ID, Timestamp startDate, Timestamp endDate) {
        log.fine("S_Resource_ID=" + S_Resource_ID);
        this.m_S_Resource_ID = S_Resource_ID;
        this.m_noDays = TimeUtil.getDaysBetween((Timestamp)startDate, (Timestamp)endDate);
        this.m_startDate = startDate;
        this.m_slots = mass;
        this.m_where = new Rectangle[this.m_slots.length];
        int i = 0;
        while (this.m_slots != null && i < this.m_slots.length) {
            MAssignmentSlot mas = this.m_slots[i];
            int dayIndex = TimeUtil.getDaysBetween((Timestamp)this.m_startDate, (Timestamp)mas.getStartTime());
            if (dayIndex < 0 || dayIndex >= this.m_noDays) {
                System.out.println("Assignment " + i + " Invalid DateRange " + mas.getInfo());
            }
            int xWidth = this.m_dayWidth / mas.getXMax();
            int xStart = dayIndex * this.m_dayWidth;
            int xEnd = (xStart += mas.getXPos() * xWidth) + xWidth;
            int yStart = this.m_timePanel.getSlotYStart(mas.getYStart());
            int yEnd = this.m_timePanel.getSlotYEnd(mas.getYEnd());
            this.m_where[i] = new Rectangle(xStart + 1, yStart + 1, xWidth - 1, yEnd - yStart - 1);
            ++i;
        }
        this.setSize();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Dimension size = this.getPreferredSize();
        Rectangle clipBounds = g2D.getClipBounds();
        int w = size.width;
        int h = size.height;
        g2D.setPaint(Color.white);
        g2D.fill3DRect(1, 1, w - 2, h - 2, true);
        if (this.m_timePanel == null) {
            return;
        }
        int headerHeight = this.m_timePanel.getHeaderHeight();
        g2D.setStroke(VScheduleTimePanel.getStroke(true));
        int i = 1;
        while (i < this.m_timePanel.getSlotCount()) {
            g2D.setPaint(Color.gray);
            int yy = this.m_timePanel.getSlotYStart(i);
            g2D.drawLine(1, yy, w - 2, yy);
            ++i;
        }
        g2D.setStroke(VScheduleTimePanel.getStroke(false));
        i = 0;
        while (i < this.m_noDays) {
            Rectangle where = new Rectangle(i * this.m_dayWidth, 0, this.m_dayWidth, headerHeight);
            if (where.intersects(clipBounds)) {
                CompiereUtils.paint3Deffect((Graphics2D)g2D, (Rectangle)where, (boolean)false, (boolean)true);
                g2D.setPaint(Color.blue);
                TextLayout layout = new TextLayout(this.getHeading(i), g2D.getFont(), g2D.getFontRenderContext());
                float hh = layout.getAscent() + layout.getDescent();
                layout.draw(g2D, (float)where.x + ((float)this.m_dayWidth - layout.getAdvance()) / 2.0f, ((float)where.height - hh) / 2.0f + layout.getAscent());
                g2D.setPaint(Color.black);
                int xEnd = (i + 1) * this.m_dayWidth;
                g2D.drawLine(xEnd, 1, xEnd, h - 1);
            }
            ++i;
        }
        i = 0;
        while (this.m_slots != null && i < this.m_slots.length) {
            if (this.m_where[i].intersects(clipBounds)) {
                g2D.setColor(this.m_slots[i].getColor(true));
                g2D.fill(this.m_where[i]);
                String string = this.m_slots[i].getInfoNameDescription();
                AttributedString as = new AttributedString(string);
                as.addAttribute(TextAttribute.FONT, g2D.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, this.m_slots[i].getColor(false));
                int startIt = string.indexOf(40);
                int endIt = string.lastIndexOf(41);
                if (startIt != -1 && endIt != -1) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIt, endIt);
                }
                AttributedCharacterIterator aci = as.getIterator();
                LineBreakMeasurer measurer = new LineBreakMeasurer(aci, g2D.getFontRenderContext());
                float wrappingWidth = this.m_where[i].width - 4;
                float curY = this.m_where[i].y + 2;
                TextLayout layout = null;
                int yEnd = this.m_where[i].y + this.m_where[i].height;
                while (measurer.getPosition() < aci.getEndIndex() && curY < (float)yEnd) {
                    layout = measurer.nextLayout(wrappingWidth);
                    if (!((curY += layout.getAscent()) < (float)yEnd)) continue;
                    layout.draw(g2D, this.m_where[i].x + 2, curY);
                }
            }
            ++i;
        }
        g2D.setPaint(Color.black);
        g2D.setStroke(VScheduleTimePanel.getStroke(false));
        g2D.drawLine(1, 1, 1, h - 1);
        g2D.drawLine(1, 1, w - 1, 1);
        g2D.drawLine(1, headerHeight, w - 1, headerHeight);
        g2D.setStroke(VScheduleTimePanel.getStroke(false));
        g2D.drawLine(w - 1, 1, w - 1, h - 1);
        g2D.drawLine(1, h - 1, w - 1, h - 1);
    }

    private String getHeading(int index) {
        GregorianCalendar cal = new GregorianCalendar();
        if (this.m_startDate != null) {
            cal.setTime(this.m_startDate);
        }
        cal.add(6, index);
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateInstance(0, Language.getLoginLanguage().getLocale());
        return format.format(cal.getTime());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        log.finer(e.toString());
        Rectangle hitRect = new Rectangle(e.getX() - 1, e.getY() - 1, 3, 3);
        int dayIndex = e.getX() / this.m_dayWidth;
        if (dayIndex >= this.m_noDays) {
            dayIndex = this.m_noDays - 1;
        }
        int timeIndex = this.m_timePanel.getTimeSlotIndex(e.getY());
        int i = 0;
        while (i < this.m_slots.length) {
            if (this.m_where[i].intersects(hitRect)) {
                MAssignmentSlot mas = this.m_slots[i];
                System.out.println("Existing=" + mas.getInfo());
                if (!mas.isAssignment()) {
                    return;
                }
                VAssignmentDialog vad = new VAssignmentDialog(Env.getFrame((Container)this), this.m_slots[i].getMAssignment(), false, this.m_createNew);
                this.m_infoSchedule.mAssignmentCallback(vad.getMResourceAssignment());
                return;
            }
            ++i;
        }
        if (this.m_createNew) {
            MResourceAssignment ma = new MResourceAssignment(Env.getCtx(), 0, null);
            ma.setS_Resource_ID(this.m_S_Resource_ID);
            ma.setAssignDateFrom(TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)this.m_startDate, (int)dayIndex), (Timestamp)this.m_timePanel.getTimeSlot(timeIndex).getStartTime()));
            ma.setQty(new BigDecimal(1));
            VAssignmentDialog vad = new VAssignmentDialog(Env.getFrame((Container)this), ma, false, this.m_createNew);
            this.m_infoSchedule.mAssignmentCallback(vad.getMResourceAssignment());
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void dispose() {
        this.m_infoSchedule = null;
        this.m_timePanel = null;
        this.m_where = null;
        this.m_slots = null;
        this.removeAll();
    }
}

