/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.Lookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoInvoice
extends Info {
    private static final long serialVersionUID = 2119484421367033632L;
    private Info_Column[] m_generalLayout;
    private ArrayList m_queryColumns = new ArrayList();
    private String m_tableName;
    private String m_keyColumn;
    private CLabel lDocumentNo = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lOrder_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID"));
    private VLookup fOrder_ID;
    private VCheckBox fIsPaid = new VCheckBox("IsPaid", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "", false);
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"), "", false);
    private CLabel lDateFrom = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DueDate"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel lDateTo = new CLabel("-");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
    private CLabel lAmtTo = new CLabel("-");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
    private static final Info_Column[] s_invoiceLayout = new Info_Column[]{new Info_Column(" ", "i.C_Invoice_ID", IDColumn.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"), "i.DateInvoiced", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DueDate"), "i.DueDate", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), "i.DocumentNo", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=i.C_Currency_ID)", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"), "currencyBase(i.GrandTotal, i.C_Currency_ID, i.DateAcct, i.AD_Client_ID, i.AD_Org_ID)", BigDecimal.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"OpenAmt"), "invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID)", BigDecimal.class, true, true, null), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "i.IsPaid", Boolean.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"), "i.IsSOTrx", Boolean.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Description"), "i.Description", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"POReference"), "i.POReference", String.class), new Info_Column("", "''", KeyNamePair.class, "i.C_InvoicePaySchedule_ID")};
    private static int INDEX_PAYSCHEDULE = s_invoiceLayout.length - 1;

    protected InfoInvoice(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "i", "C_Invoice_ID", multiSelection, whereClause);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoInvoice"));
        try {
            this.statInit();
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.fDocumentNo.setValue((Object)value);
            this.executeQuery();
        }
        this.pack();
        this.fDocumentNo.requestFocus();
    }

    private void statInit() throws Exception {
        this.lDocumentNo.setLabelFor((Component)this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener((ActionListener)((Object)this));
        this.lDescription.setLabelFor((Component)this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener((ActionListener)((Object)this));
        this.fIsPaid.setSelected(false);
        this.fIsPaid.addActionListener((ActionListener)((Object)this));
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx")));
        this.fIsSOTrx.addActionListener((ActionListener)((Object)this));
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30));
        this.lBPartner_ID.setLabelFor((Component)this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrder_ID = new VLookup("C_Order_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)4247, (int)30));
        this.lOrder_ID.setLabelFor((Component)this.fOrder_ID);
        this.fOrder_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor((Component)this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.lDateTo.setLabelFor((Component)this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.lAmtFrom.setLabelFor((Component)this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
        this.lAmtTo.setLabelFor((Component)this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
        this.parameterPanel.setLayout((LayoutManager)new ALayout());
        this.parameterPanel.add((Component)this.lDocumentNo, (Object)new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fDocumentNo, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.fIsSOTrx, (Object)new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.fIsPaid, null);
        this.parameterPanel.add((Component)this.lDescription, (Object)new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fDescription, null);
        this.parameterPanel.add((Component)this.lDateFrom, null);
        this.parameterPanel.add((Component)this.fDateFrom, null);
        this.parameterPanel.add((Component)this.lDateTo, null);
        this.parameterPanel.add((Component)this.fDateTo, null);
        this.parameterPanel.add((Component)this.lOrder_ID, (Object)new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fOrder_ID, null);
        this.parameterPanel.add((Component)this.lAmtFrom, null);
        this.parameterPanel.add((Component)this.fAmtFrom, null);
        this.parameterPanel.add((Component)this.lAmtTo, null);
        this.parameterPanel.add((Component)this.fAmtTo, null);
    }

    private boolean initInfo() {
        String bp = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.fBPartner_ID.setValue((Object)new Integer(bp));
        }
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace((String)this.p_whereClause, (String)"C_Invoice.", (String)"i."));
        }
        this.prepareTable(s_invoiceLayout, " C_Invoice_v i", where.toString(), "2,3,4");
        return true;
    }

    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.fDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (this.fDescription.getText().length() > 0) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (this.fOrder_ID.getValue() != null) {
            sql.append(" AND i.C_Order_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(i.DueDate) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(i.DueDate) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.DueDate) BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND i.GrandTotal <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND i.GrandTotal >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND i.GrandTotal BETWEEN ? AND ?");
            }
        }
        sql.append(" AND i.IsPaid=? AND i.IsSOTrx=?");
        return sql.toString();
    }

    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDocumentNo));
        }
        if (this.fDescription.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDescription));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fOrder_ID.getValue() != null) {
            Integer order = (Integer)this.fOrder_ID.getValue();
            pstmt.setInt(index++, order);
            this.log.fine("Order=" + order);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, this.fIsPaid.isSelected() ? "Y" : "N");
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = String.valueOf(s) + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    protected void zoom() {
        this.log.info("InfoInvoice.zoom");
        Integer C_Invoice_ID = this.getSelectedRowKey();
        if (C_Invoice_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Invoice");
        query.addRestriction("C_Invoice_ID", "=", (Object)C_Invoice_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Invoice", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    protected boolean hasZoom() {
        return true;
    }

    protected void saveSelectionDetail() {
        Object value;
        Integer ID = this.getSelectedRowKey();
        Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_Invoice_ID", (String)(ID == null ? "0" : ID.toString()));
        int C_InvoicePaySchedule_ID = 0;
        int row = this.p_table.getSelectedRow();
        if (row >= 0 && (value = this.p_table.getValueAt(row, INDEX_PAYSCHEDULE)) != null && value instanceof KeyNamePair) {
            C_InvoicePaySchedule_ID = ((KeyNamePair)value).getKey();
        }
        if (C_InvoicePaySchedule_ID <= 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)"0");
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)String.valueOf(C_InvoicePaySchedule_ID));
        }
    }
}

