/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.X_MP_MaintainDetail;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.model.X_MP_OT_Task;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.ofb.model.OFBForward;

public class VMPGenerateOTTSM
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener,
ASyncProcess {
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMPGenerateOTTSM.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private CPanel mainPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel allocationPanel = new CPanel();
    private MiniTable selectedTable = new MiniTable();
    private MiniTable prognosisTable = new MiniTable();
    private CPanel infoPanel = new CPanel();
    private int m_A_Asset_ID = 0;
    private CPanel prognosisPanel = new CPanel();
    private CPanel selectedPanel = new CPanel();
    private JLabel prognosisLabel = new JLabel();
    private JLabel selectedLabel = new JLabel();
    private BorderLayout prognosisLayout = new BorderLayout();
    private BorderLayout selectedLayout = new BorderLayout();
    private JLabel prognosisInfo = new JLabel();
    private JScrollPane prognosisScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton ProcessButton = new JButton();
    private JButton searchButton = new JButton();
    private JButton addButton = new JButton();
    private JButton EnableButton = new JButton();
    private JButton ChangeButton = new JButton();
    private JLabel assetLabel = new JLabel();
    private JCheckBox selectall = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private VLookup assetSearch = null;

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)((Object)this));
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.prognosisLabel.setRequestFocusEnabled(false);
        this.prognosisLabel.setText("Mantenciones Pronosticadas");
        this.selectedLabel.setRequestFocusEnabled(false);
        this.selectedLabel.setText("seleccionadas");
        this.prognosisPanel.setLayout((LayoutManager)this.prognosisLayout);
        this.selectedPanel.setLayout((LayoutManager)this.selectedLayout);
        this.prognosisInfo.setHorizontalAlignment(4);
        this.prognosisInfo.setHorizontalTextPosition(4);
        this.prognosisInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.ProcessButton.setText("Generar OT");
        this.ProcessButton.addActionListener(this);
        this.searchButton.setText("Buscar");
        this.searchButton.addActionListener(this);
        this.addButton.setText("Agregar Seleccion");
        this.addButton.addActionListener(this);
        this.EnableButton.setText("Habilitar Edicion");
        this.EnableButton.addActionListener(this);
        this.ChangeButton.setText("Aplicar Fecha");
        this.ChangeButton.addActionListener(this);
        this.assetLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"A_Asset_ID"));
        this.selectall.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Seleccionar Todo"));
        this.selectall.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.prognosisScrollPane.setPreferredSize(new Dimension(300, 300));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.ChangeButton, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.selectall, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetLabel, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetSearch, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.ProcessButton, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.prognosisPanel.add((Component)this.prognosisLabel, (Object)"North");
        this.prognosisPanel.add((Component)this.prognosisInfo, (Object)"South");
        this.prognosisPanel.add((Component)this.prognosisScrollPane, (Object)"Center");
        this.prognosisScrollPane.getViewport().add((Component)((Object)this.prognosisTable), null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setLayout((LayoutManager)new BorderLayout());
        this.infoPanel.add((Component)this.prognosisPanel, (Object)"Center");
        this.infoPanel.setPreferredSize(new Dimension(1000, 450));
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID((String)"MP_Maintain", (String)"A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.assetSearch = new VLookup("A_Asset_ID", true, false, true, (Lookup)lookupBP);
        this.assetSearch.addVetoableChangeListener((VetoableChangeListener)this);
        this.dateField.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.statusBar.setStatusLine("Seleccione la mantencion, cambie la fecha pronosticada o genere directamente la OT ");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select p.AD_PINSTANCE_ID,p.AD_CLIENT_ID,p.AD_ORG_ID,p.A_ASSET_ID,p.MP_MAINTAINDetail_ID,p.DESCRIPTION,p.PROGRAMMINGTYPE,p.CICLO,p.DATETRX,mp.Description as MP_name,a.value||'-'||a.name as assetname   from MP_Prognosis p Inner Join MP_MainTainDetail mp on (p.MP_MAINTAINDetail_ID=mp.MP_MAINTAINDetail_ID) Inner Join A_Asset a on (p.A_ASSET_ID=a.A_ASSET_ID) where p.Processed='N' and p.Selected='N' " + (this.m_A_Asset_ID > 0 ? " and p.A_Asset_ID = " + this.m_A_Asset_ID : " and p.A_Asset_ID = 0") + " order by p.DATETRX asc");
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getInt(8));
                line.add(rs.getTimestamp(9));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(11));
                line.add(pp);
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(5), rs.getString("MP_name"));
                line.add(pp2);
                line.add(rs.getString(7));
                line.add(rs.getString(6));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.prognosisTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Generar OT");
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Ciclo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"Asset")));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"MP"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Programing Type"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Description"));
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.prognosisTable.setModel(modelP);
        int i = 0;
        this.prognosisTable.setColumnClass(i++, Boolean.class, false);
        this.prognosisTable.setColumnClass(i++, Integer.class, true);
        this.prognosisTable.setColumnClass(i++, Timestamp.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.autoSize();
        this.prognosisTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        log.config("");
                        if (!e.getSource().equals(this.ProcessButton)) break block6;
                        this.saveData();
                        break block7;
                    }
                    if (!e.getSource().equals(this.EnableButton)) break block8;
                    this.prognosisTable.setColumnReadOnly(1, false);
                    this.prognosisTable.setColumnReadOnly(2, false);
                    this.prognosisTable.setColumnReadOnly(3, false);
                    break block7;
                }
                if (!e.getSource().equals(this.ChangeButton)) break block9;
                this.ProcessButton.setEnabled(true);
                TableModel prognosis = this.prognosisTable.getModel();
                int rows = prognosis.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                        prognosis.setValueAt(DateTrx, i, 2);
                    }
                    ++i;
                }
                break block7;
            }
            if (!e.getSource().equals(this.selectall)) break block7;
            TableModel prognosis = this.prognosisTable.getModel();
            int rows = prognosis.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        Object allocDate = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
            this.loadMPs();
        }
    }

    private void saveData() {
        TableModel prognosis = this.prognosisTable.getModel();
        int rows = prognosis.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 4);
                int MPD_ID = pp.getKey();
                pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)prognosis.getValueAt(i, 2);
                String description = (String)prognosis.getValueAt(i, 6);
                int ciclo = (Integer)prognosis.getValueAt(i, 1);
                String ProgramingType = (String)prognosis.getValueAt(i, 5);
                if (!this.createOT(MPD_ID, Datetrx, description, Asset_ID)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    this.updateMPD(MPD_ID, Datetrx, description);
                    String sql = "Update MP_Prognosis set Processed='Y' where ciclo=" + ciclo + " and MP_MAINTAINDetail_ID=" + MPD_ID + " and A_Asset_ID=" + Asset_ID + " and PROGRAMMINGTYPE='" + ProgramingType + "'";
                    DB.executeUpdate((String)sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    public boolean createOT(int MPD_ID, Timestamp Datetrx, String description, int Asset_ID) {
        int MP_ID = new X_MP_MaintainDetail(Env.getCtx(), MPD_ID, null).getMP_Maintain_ID();
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_Maintain_ID(MP_ID);
        newOT.set_CustomColumn("MP_MaintainDetail_ID", MPD_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"OTP")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        if (!this.createOTTaskDetail(MP_ID, newOT, MPD_ID)) {
            return false;
        }
        String sql = "select mp_maintain_id,mp_maintainDetail_id from mp_maintainDetail where ischild='Y' and MP_MAINTAINPARENT_ID=? and A_Asset_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, MP_ID);
            pstmt.setInt(2, Asset_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), newOT, rs.getInt(2));
                this.lookChilds(rs.getInt(1), newOT, rs.getInt(2), Asset_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }

    public void lookChilds(int MP_ID, X_MP_OT OT, int MPD_ID, int Asset_ID) {
        String sql = "select mp_maintain_id,mp_maintainDetail_id from mp_maintainDetail where ischild='Y' and MP_MAINTAINPARENT_ID=? and A_Asset_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, MP_ID);
            pstmt.setInt(2, Asset_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), OT, rs.getInt(2));
                this.lookChilds(rs.getInt(1), OT, rs.getInt(2), Asset_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public boolean createOTTaskDetail(int MP_ID, X_MP_OT OT, int MPD_ID) {
        String sql = "select * from MP_MAINTAIN_TASK where MP_MAINTAIN_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Task ta = new X_MP_OT_Task(Env.getCtx(), 0, null);
                ta.setMP_Maintain_ID(MP_ID);
                ta.set_CustomColumn("MP_MaintainDetail_ID", MPD_ID);
                ta.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                ta.setMP_OT_ID(OT.getMP_OT_ID());
                ta.setDescription(rs.getString("Description"));
                ta.setDuration(rs.getBigDecimal("Duration"));
                ta.setC_UOM_ID(rs.getInt("C_UOM_ID"));
                ta.setStatus("NS");
                ta.saveEx();
                this.createOTResourceDetail(rs.getInt("MP_MAINTAIN_TASK_ID"), ta.getMP_OT_Task_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (OFBForward.NewUpdateMantainceDetailTSM()) {
            this.updateMPDTSM(OT.get_ValueAsInt("MP_MaintainDetail_ID"), OT.getDateTrx(), OT.getDescription(), OT);
        } else {
            this.updateMPD(OT.get_ValueAsInt("MP_MaintainDetail_ID"), OT.getDateTrx(), OT.getDescription());
        }
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        String sql = "select * from MP_MAINTAIN_RESOURCE where MP_MAINTAIN_TASK_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, oldTask_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(newTask_ID);
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY"));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }

    public void updateMPD(int MPD_ID, Timestamp Datetrx, String description) {
        X_MP_MaintainDetail mp = new X_MP_MaintainDetail(Env.getCtx(), MPD_ID, null);
        mp.setdatelastrunmp(Datetrx);
        mp.setDateLastRun(Datetrx);
        if (mp.isProgrammingType().equals("C")) {
            mp.setDateNextRun(new Timestamp(Datetrx.getTime() + mp.getInterval().longValue() * 86400000L));
        } else {
            mp.setnextmp(mp.getInterval().add(mp.getlastread()).setScale(2, 6));
            mp.setlastmp(new BigDecimal(Float.parseFloat(description.split(":")[description.split(":").length - 1].replace(',', '.'))).setScale(2, 6));
        }
        mp.save();
    }

    public void updateMPDTSM(int MPD_ID, Timestamp Datetrx, String description, X_MP_OT OT) {
        X_MP_MaintainDetail mp = new X_MP_MaintainDetail(Env.getCtx(), MPD_ID, null);
        mp.setdatelastrunmp(Datetrx);
        mp.setDateLastRun(Datetrx);
        if (mp.isProgrammingType().equals("C")) {
            mp.setDateNextRun(new Timestamp(Datetrx.getTime() + mp.getInterval().longValue() * 86400000L));
        } else {
            BigDecimal actualKm = (BigDecimal)OT.get_Value("tsm_km");
            if (actualKm != null) {
                mp.setnextmp(mp.getInterval().add(actualKm).setScale(2, 6));
            } else {
                mp.setnextmp(mp.getInterval().add(mp.getlastread()).setScale(2, 6));
            }
            mp.setlastmp(new BigDecimal(Float.parseFloat(description.split(":")[description.split(":").length - 1].replace(',', '.'))).setScale(2, 6));
        }
        mp.save();
    }

    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isUILocked() {
        return this.isEnabled();
    }

    public void executeASync(ProcessInfo pi) {
    }
}

