/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLocationDialog;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRMA;
import org.compiere.model.MRefList;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VInOutGenOFBUnConsolidate
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = -8529925342013824806L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private boolean m_selectionActive = true;
    private Object m_M_Warehouse_ID = null;
    private Object m_C_BPartner_ID = null;
    private static CLogger log = CLogger.getCLogger(VInOutGenOFBUnConsolidate.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lWarehouse = new CLabel();
    private VLookup fWarehouse;
    private CLabel lBPartner = new CLabel();
    private VLookup fBPartner;
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CLabel lDocType = new CLabel();
    private VComboBox cmbDocType = new VComboBox();
    private CLabel lDocAction = new CLabel();
    private VLookup docAction;
    private ArrayList<Integer> selection = null;

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", (Throwable)ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)((Object)this));
        this.selPanel.setLayout((LayoutManager)this.selPanelLayout);
        this.lWarehouse.setLabelFor((Component)this.fWarehouse);
        this.lBPartner.setLabelFor((Component)this.fBPartner);
        this.lBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.lDocAction.setLabelFor((Component)this.docAction);
        this.lDocAction.setText(Msg.translate((Properties)Env.getCtx(), (String)"DocAction"));
        this.selNorthPanel.setLayout((LayoutManager)this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, (Object)"Seleccion para Consolidado");
        this.selPanel.add((Component)this.selNorthPanel, (Object)"North");
        this.selNorthPanel.add((Component)this.lWarehouse, null);
        this.selNorthPanel.add((Component)this.fWarehouse, null);
        this.selNorthPanel.add((Component)this.lBPartner, null);
        this.selNorthPanel.add((Component)this.fBPartner, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, (Object)"South");
        this.selPanel.add((Component)this.scrollPane, (Object)"Center");
        this.scrollPane.getViewport().add((Component)((Object)this.miniTable), null);
        this.confirmPanelSel.addActionListener((ActionListener)this);
        this.tabbedPane.add((Component)this.genPanel, (Object)Msg.getMsg((Properties)Env.getCtx(), (String)"Generate"));
        this.genPanel.setLayout((LayoutManager)this.genLayout);
        this.genPanel.add((Component)this.info, (Object)"Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, (Object)"South");
        this.confirmPanelGen.addActionListener((ActionListener)this);
        this.lDocType.setLabelFor((Component)this.cmbDocType);
        this.selNorthPanel.add((Component)this.lDocType, null);
        this.selNorthPanel.add((Component)this.cmbDocType, null);
        this.selNorthPanel.add((Component)this.lDocAction, null);
        this.selNorthPanel.add((Component)this.docAction, null);
    }

    private void fillPicks() throws Exception {
        MLookup orgL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)2223, (int)19);
        this.fWarehouse = new VLookup("M_Warehouse_ID", true, false, true, (Lookup)orgL);
        this.lWarehouse.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.fWarehouse.addVetoableChangeListener((VetoableChangeListener)this);
        this.m_M_Warehouse_ID = this.fWarehouse.getValue();
        MLookup docActionL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)4324, (int)17, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"DocAction", (int)135, (boolean)false, (String)"AD_Ref_List.Value IN ('CO','PR')");
        this.docAction = new VLookup("DocAction", true, false, true, (Lookup)docActionL);
        Object[] arr = null;
        this.docAction.setValue((Object)DB.getSQLValueString((String)"AD_Client", (String)("select InOutStatus from AD_Client where AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx())), arr));
        this.docAction.addVetoableChangeListener((VetoableChangeListener)this);
        MLookup bpL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)2762, (int)30);
        this.fBPartner = new VLookup("C_BPartner_ID", false, false, true, (Lookup)bpL);
        this.lBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.fBPartner.addVetoableChangeListener((VetoableChangeListener)this);
        this.lDocType.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.cmbDocType.addItem((Object)new KeyNamePair(MOrder.Table_ID, Msg.translate((Properties)Env.getCtx(), (String)"Order")));
        this.cmbDocType.addItem((Object)new KeyNamePair(MRMA.Table_ID, Msg.translate((Properties)Env.getCtx(), (String)"VendorRMA")));
        this.cmbDocType.addActionListener((ActionListener)this);
    }

    private void dynInit() {
        this.miniTable.addColumn("C_Order_ID");
        this.miniTable.addColumn("AD_Org_ID");
        if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
            this.miniTable.addColumn("C_Zone_ID");
        }
        this.miniTable.addColumn("C_DocType_ID");
        this.miniTable.addColumn("DocumentNo");
        this.miniTable.addColumn("Description");
        this.miniTable.addColumn("C_BPartner_ID");
        this.miniTable.addColumn("DateOrdered");
        this.miniTable.addColumn("Location");
        this.miniTable.addColumn("TotalLines");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
            this.miniTable.setColumnClass(2, String.class, true, "Zona");
            this.miniTable.setColumnClass(3, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
            this.miniTable.setColumnClass(4, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
            this.miniTable.setColumnClass(5, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Description"));
            this.miniTable.setColumnClass(6, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
            this.miniTable.setColumnClass(7, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DateOrdered"));
            this.miniTable.setColumnClass(8, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Location"));
            this.miniTable.setColumnClass(9, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"TotalLines"));
        } else {
            this.miniTable.setColumnClass(2, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
            this.miniTable.setColumnClass(3, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
            this.miniTable.setColumnClass(4, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Description"));
            this.miniTable.setColumnClass(5, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
            this.miniTable.setColumnClass(6, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DateOrdered"));
            this.miniTable.setColumnClass(7, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Location"));
            this.miniTable.setColumnClass(8, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"TotalLines"));
        }
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"InOutGenerateSel"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener((ChangeListener)this);
    }

    private String getOrderSQL() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer("SELECT C_Order_ID, o.Name, dt.Name, ic.DocumentNo, bp.Name, DateOrdered, TotalLines, ic.Description, ic.C_BPartner_ID FROM M_InOut_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_M_Warehouse_ID != null) {
            sql.append(" AND ic.M_Warehouse_ID=").append(this.m_M_Warehouse_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere((int)MOrder.Table_ID, (int)(AD_User_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID")))) != null) {
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append("C_Order_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        return sql.toString();
    }

    private String getRMASql() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT rma.M_RMA_ID, org.Name, dt.Name, rma.DocumentNo, bp.Name, rma.Created, rma.Amt ");
        sql.append("FROM M_RMA rma INNER JOIN AD_Org org ON rma.AD_Org_ID=org.AD_Org_ID ");
        sql.append("INNER JOIN C_DocType dt ON rma.C_DocType_ID=dt.C_DocType_ID ");
        sql.append("INNER JOIN C_BPartner bp ON rma.C_BPartner_ID=bp.C_BPartner_ID ");
        sql.append("INNER JOIN M_InOut io ON rma.InOut_ID=io.M_InOut_ID ");
        sql.append("WHERE rma.DocStatus='CO' ");
        sql.append("AND dt.DocBaseType = 'POO' ");
        sql.append("AND EXISTS (SELECT * FROM M_RMA r INNER JOIN M_RMALine rl ");
        sql.append("ON r.M_RMA_ID=rl.M_RMA_ID WHERE r.M_RMA_ID=rma.M_RMA_ID ");
        sql.append("AND rl.IsActive='Y' AND rl.M_InOutLine_ID > 0 AND rl.QtyDelivered < rl.Qty) ");
        sql.append("AND NOT EXISTS (SELECT * FROM M_InOut oio WHERE oio.M_RMA_ID=rma.M_RMA_ID ");
        sql.append("AND oio.DocStatus IN ('IP', 'CO', 'CL')) ");
        sql.append("AND rma.AD_Client_ID=?");
        if (this.m_M_Warehouse_ID != null) {
            sql.append(" AND io.M_Warehouse_ID=").append(this.m_M_Warehouse_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND bp.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere((int)MRMA.Table_ID, (int)(AD_User_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID")))) != null) {
            sql.append(" AND rma.M_RMA_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY org.Name, bp.Name, rma.Created ");
        return sql.toString();
    }

    private void executeQuery() {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        String sql = "";
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        sql = docTypeKNPair.getKey() == MRMA.Table_ID ? this.getRMASql() : this.getOrderSQL();
        log.fine(sql);
        int row = 0;
        this.miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int Zone_ID = 0;
                String location = DB.getSQLValueString(null, (String)"select name from C_BPARTNER_LOCATION where ISSHIPTO='Y' and C_BPartner_ID=?", (int)rs.getInt(9));
                int Location_ID = DB.getSQLValue(null, (String)"select C_Location_ID from C_BPARTNER_LOCATION where ISSHIPTO='Y' and C_BPartner_ID=?", (int)rs.getInt(9));
                if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
                    Zone_ID = DB.getSQLValue(null, (String)("select C_Zone_ID from C_Location where C_Location_ID=" + Location_ID));
                }
                int column = 0;
                this.miniTable.setRowCount(row + 1);
                this.miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, column);
                this.miniTable.setValueAt(rs.getString(2), row, ++column);
                if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
                    if (Zone_ID > 0) {
                        this.miniTable.setValueAt(new MRefList(Env.getCtx(), Zone_ID, null).getName(), row, ++column);
                    } else {
                        this.miniTable.setValueAt(new String(""), row, ++column);
                    }
                }
                this.miniTable.setValueAt(rs.getString(3), row, ++column);
                this.miniTable.setValueAt(rs.getString(4), row, ++column);
                if (rs.getString(8) != null) {
                    if (rs.getString(8).length() > 80) {
                        this.miniTable.setValueAt(rs.getString(8).substring(0, 79), row, ++column);
                    } else {
                        this.miniTable.setValueAt(rs.getString(8), row, ++column);
                    }
                } else {
                    this.miniTable.setValueAt("", row, ++column);
                }
                this.miniTable.setValueAt(rs.getString(5), row, ++column);
                this.miniTable.setValueAt(rs.getTimestamp(6), row, ++column);
                this.miniTable.setValueAt(location, row, ++column);
                this.miniTable.setValueAt(rs.getBigDecimal(7), row, ++column);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.miniTable.autoSize();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (this.cmbDocType.equals(e.getSource())) {
            this.executeQuery();
            return;
        }
        this.saveSelection();
        if (this.selection != null && this.selection.size() > 0 && this.m_selectionActive && this.m_M_Warehouse_ID != null) {
            this.generateShipments();
        } else {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        log.info(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName().equals("M_Warehouse_ID")) {
            this.m_M_Warehouse_ID = e.getNewValue();
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.m_C_BPartner_ID = e.getNewValue();
            this.fBPartner.setValue(this.m_C_BPartner_ID);
        }
        this.executeQuery();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = index == 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                ++rowsSelected;
            }
            ++i;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    private void saveSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.selection = null;
        int rows = this.miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                results.add(id.getRecord_ID());
            }
            ++i;
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.selection = results;
    }

    private void generateShipments() {
        log.info("M_Warehouse_ID=" + this.m_M_Warehouse_ID);
        String trxName = Trx.createTrxName((String)"IOG");
        Trx trx = Trx.get((String)trxName, (boolean)true);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"InOutGenerateGen"));
        this.statusBar.setStatusDB(String.valueOf(this.selection.size()));
        int AD_Process_ID = 0;
        AD_Process_ID = DB.getSQLValue((String)trx.getTrxName(), (String)"select AD_Process_ID from AD_Process where Name='InOutGenerateOFBTotal'");
        if (AD_Process_ID <= 0) {
            String msg = "No Process InOutGenerateOFB";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            this.info.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
            return;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.selection) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate((String)insert.toString(), (String)trxName) < 0) {
                String msg = "No Shipments";
                log.config(msg);
                this.info.setText(msg);
                trx.rollback();
                return;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate((String)insert.toString(), (String)trxName) < 0) {
            String msg = "No Shipments";
            log.config(msg);
            this.info.setText(msg);
            trx.rollback();
            return;
        }
        ProcessInfo pi = new ProcessInfo("VInOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ip = new MPInstancePara(instance, 20);
        String docActionSelected = (String)this.docAction.getValue();
        ip.setParameter("DocAction", docActionSelected);
        if (!ip.save()) {
            String msg = "No DocACtion Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", Integer.parseInt(this.m_M_Warehouse_ID.toString()));
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ip = new MPInstancePara(instance, 40);
        ip.setParameter("ConsolidateDocument", "N");
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ProcessCtl worker = new ProcessCtl((ASyncProcess)this, Env.getWindowNo((Container)((Object)this)), pi, trx);
        worker.start();
    }

    private void generateShipments_complete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        StringBuffer iText = new StringBuffer();
        iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg((Properties)Env.getCtx(), (String)"InOutGenerateInfo")).append(")<br>").append(pi.getLogInfo(true));
        this.info.setText(iText.toString());
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        log.config("PrintItems=" + ids.length);
        this.confirmPanelGen.getOKButton().setEnabled(false);
        boolean print = false;
        int i = 0;
        while (i < ids.length) {
            if (ids[i] != 0) {
                print = true;
            }
            ++i;
        }
        if (print && ADialog.ask((int)this.m_WindowNo, (Container)((Object)this), (String)"PrintShipments")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                int i2 = 0;
                while (i2 < ids.length) {
                    int M_InOut_ID = ids[i2];
                    if (M_InOut_ID != 0) {
                        ReportCtl.startDocumentPrint((int)1, (int)M_InOut_ID, (ASyncProcess)this, (int)Env.getWindowNo((Container)((Object)this)), (boolean)true);
                    }
                    ++i2;
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader((Properties)Env.getCtx(), (int)this.m_WindowNo), Msg.getMsg((Properties)Env.getCtx(), (String)"PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }

    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.generateShipments_complete(pi);
    }

    public boolean isUILocked() {
        return this.isEnabled();
    }

    public void executeASync(ProcessInfo pi) {
    }
}

