/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MFactAcct;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

class Doc_AllocationTax {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private MAccount m_DiscountAccount;
    private BigDecimal m_DiscountAmt;
    private MAccount m_WriteOffAccount;
    private BigDecimal m_WriteOffAmt;
    private boolean m_IsSOTrx;
    private ArrayList<MFactAcct> m_facts = new ArrayList();
    private int m_totalIndex = 0;

    public Doc_AllocationTax(MAccount DiscountAccount, BigDecimal DiscountAmt, MAccount WriteOffAccount, BigDecimal WriteOffAmt, boolean isSOTrx) {
        this.m_DiscountAccount = DiscountAccount;
        this.m_DiscountAmt = DiscountAmt;
        this.m_WriteOffAccount = WriteOffAccount;
        this.m_WriteOffAmt = WriteOffAmt;
        this.m_IsSOTrx = isSOTrx;
    }

    public void addInvoiceFact(MFactAcct fact) {
        this.m_facts.add(fact);
    }

    public int getLineCount() {
        return this.m_facts.size();
    }

    public boolean createEntries(MAcctSchema as, Fact fact, DocLine line) {
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < this.m_facts.size()) {
            MFactAcct factAcct = this.m_facts.get(i);
            if (factAcct.getAmtSourceDr().compareTo(total) > 0) {
                total = factAcct.getAmtSourceDr();
                this.m_totalIndex = i;
            }
            if (factAcct.getAmtSourceCr().compareTo(total) > 0) {
                total = factAcct.getAmtSourceCr();
                this.m_totalIndex = i;
            }
            ++i;
        }
        MFactAcct factAcct = this.m_facts.get(this.m_totalIndex);
        this.log.info("Total Invoice = " + total + " - " + factAcct);
        int precision = as.getStdPrecision();
        int i2 = 0;
        while (i2 < this.m_facts.size()) {
            if (i2 != this.m_totalIndex) {
                BigDecimal amount;
                factAcct = this.m_facts.get(i2);
                this.log.info(String.valueOf(i2) + ": " + factAcct);
                MAccount taxAcct = factAcct.getMAccount();
                if (taxAcct == null || taxAcct.get_ID() == 0) {
                    this.log.severe("Tax Account not found/created");
                    return false;
                }
                if (this.m_DiscountAmt.signum() != 0) {
                    if (Env.ZERO.compareTo(factAcct.getAmtSourceDr()) != 0) {
                        amount = this.calcAmount(factAcct.getAmtSourceDr(), total, this.m_DiscountAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                fact.createLine(line, this.m_DiscountAccount, as.getC_Currency_ID(), amount, null);
                                fact.createLine(line, taxAcct, as.getC_Currency_ID(), null, amount);
                            } else {
                                fact.createLine(line, this.m_DiscountAccount, as.getC_Currency_ID(), amount.negate(), null);
                                fact.createLine(line, taxAcct, as.getC_Currency_ID(), null, amount.negate());
                            }
                        }
                    } else {
                        amount = this.calcAmount(factAcct.getAmtSourceCr(), total, this.m_DiscountAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                fact.createLine(line, taxAcct, as.getC_Currency_ID(), amount, null);
                                fact.createLine(line, this.m_DiscountAccount, as.getC_Currency_ID(), null, amount);
                            } else {
                                fact.createLine(line, taxAcct, as.getC_Currency_ID(), amount.negate(), null);
                                fact.createLine(line, this.m_DiscountAccount, as.getC_Currency_ID(), null, amount.negate());
                            }
                        }
                    }
                }
                if (this.m_WriteOffAmt.signum() != 0) {
                    if (Env.ZERO.compareTo(factAcct.getAmtSourceDr()) != 0) {
                        amount = this.calcAmount(factAcct.getAmtSourceDr(), total, this.m_WriteOffAmt, precision);
                        if (amount.signum() != 0) {
                            fact.createLine(line, this.m_WriteOffAccount, as.getC_Currency_ID(), amount, null);
                            fact.createLine(line, taxAcct, as.getC_Currency_ID(), null, amount);
                        }
                    } else {
                        amount = this.calcAmount(factAcct.getAmtSourceCr(), total, this.m_WriteOffAmt, precision);
                        if (amount.signum() != 0) {
                            fact.createLine(line, taxAcct, as.getC_Currency_ID(), amount, null);
                            fact.createLine(line, this.m_WriteOffAccount, as.getC_Currency_ID(), null, amount);
                        }
                    }
                }
            }
            ++i2;
        }
        return true;
    }

    private BigDecimal calcAmount(BigDecimal tax, BigDecimal total, BigDecimal amt, int precision) {
        this.log.fine("Amt=" + amt + " - Total=" + total + ", Tax=" + tax);
        if (tax.signum() == 0 || total.signum() == 0 || amt.signum() == 0) {
            return Env.ZERO;
        }
        BigDecimal multiplier = tax.divide(total, 10, 4);
        BigDecimal retValue = multiplier.multiply(amt);
        if (retValue.scale() > precision) {
            retValue = retValue.setScale(precision, 4);
        }
        this.log.fine(retValue + " (Mult=" + multiplier + "(Prec=" + precision + ")");
        return retValue;
    }
}

