/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateInventoryUseInternal
extends SvrProcess {
    protected void prepare() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        String sqlDet = "SELECT cab.I_IMPORTCONSUMPTIONW_ID, cab.AD_ORG_ID, cab.NRODOC,FECHADOC, ALMACEN,cab.ISABORT,DESCRIPTION2,  det.I_IMPORTCONSUMPTIONWL_ID, det.ISABORT as ISABORTDET,CODPROD,COSTO, det.NRODOC as NRODOCDET, TIPOMOV,CANT, det.CENTROCOSTO  FROM I_IMPORTCONSUMPTIONW cab  LEFT JOIN I_IMPORTCONSUMPTIONWL det ON (cab.NRODOC = det.NRODOC) WHERE cab.processed = 'N' AND (det.processed = 'N' OR det.processed IS NULL)  Order By cab.NRODOC Desc, I_IMPORTCONSUMPTIONWL_ID ASC";
        this.log.config("sqldet " + sqlDet);
        CPreparedStatement pstmt = null;
        int cant = 0;
        String ID_movXML = "0";
        String ID_movXMLLine = "0";
        try {
            pstmt = DB.prepareStatement((String)sqlDet, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int LastMov = -1;
            int id_MovAD = 0;
            MInventory mov = null;
            while (true) {
                if (!rs.next()) {
                    if (mov != null && mov.getDocStatus().compareTo("DR") == 0) {
                        mov.processIt("CO");
                        mov.saveEx(this.get_TrxName());
                    }
                    this.log.config("Se han generado " + cant + " documentos");
                    DB.executeUpdate((String)("UPDATE I_IMPORTCONSUMPTIONW SET processed = 'Y' WHERE I_IMPORTCONSUMPTIONW_ID IN (" + ID_movXML + ")"), (String)this.get_TrxName());
                    DB.executeUpdate((String)("UPDATE I_IMPORTCONSUMPTIONWL SET processed = 'Y' WHERE I_IMPORTCONSUMPTIONWL_ID IN (" + ID_movXMLLine + ")"), (String)this.get_TrxName());
                    rs.close();
                    pstmt.close();
                    return "OK";
                }
                id_MovAD = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(M_Inventory_ID) FROM M_Inventory  WHERE DocumentNo = '" + rs.getString("NRODOC") + "' AND DocStatus IN ('DR','IP','CO')"));
                if (id_MovAD != LastMov) {
                    if (mov != null) {
                        mov.processIt("CO");
                        mov.save();
                    }
                    mov = new MInventory(this.getCtx(), 0, this.get_TrxName());
                    mov.setDocumentNo(rs.getString("NRODOC"));
                    mov.setAD_Org_ID(1000023);
                    String sqldoctype = "SELECT coalesce(max(c_doctype_id),0) from c_doctype where name like 'WSConsumoProduccion' and AD_Client_ID = " + Env.getAD_Client_ID((Properties)this.getCtx());
                    int doctype = DB.getSQLValue((String)this.get_TrxName(), (String)sqldoctype);
                    if (doctype <= 0) {
                        return "No existe tipo de documentos";
                    }
                    mov.setC_DocType_ID(doctype);
                    mov.setDescription("Insertado XML. " + rs.getString("DESCRIPTION2"));
                    int ID_Bodega = 1000038;
                    mov.setM_Warehouse_ID(ID_Bodega);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date parsedDate = dateFormat.parse(rs.getString("FECHADOC"));
                    Timestamp dateDoc = new Timestamp(parsedDate.getTime());
                    if (dateDoc != null) {
                        mov.setMovementDate(dateDoc);
                    }
                    String sqldocumentno = "SELECT count(1) from m_inventory where documentno like '" + rs.getString("NRODOC") + "' and c_doctype_id = " + doctype + " and m_inventory_id != " + mov.get_ID();
                    this.log.config("obtener nro documento existente " + sqldocumentno);
                    int cantidaddoc = DB.getSQLValue((String)this.get_TrxName(), (String)sqldocumentno);
                    if (cantidaddoc > 0) {
                        DB.executeUpdate((String)("UPDATE i_importconsumptionw set description2 = 'NRO DOCUMENTO YA EXISTE', isabort='Y' where i_importconsumptionw_id = " + rs.getInt("I_ImportConsumptionw_ID")), (String)this.get_TrxName());
                        return "Ya existe el nro de documento " + rs.getInt("I_ImportConsumptionW_ID");
                    }
                    mov.save();
                    ++cant;
                }
                MInventoryLine line = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
                String sqlorg = "SELECT coalesce(AD_Org_ID,0) FROM AD_Org where name like '" + rs.getString("CENTROCOSTO") + "'";
                this.log.config("sql org " + sqlorg);
                int id_orgline = DB.getSQLValue((String)this.get_TrxName(), (String)sqlorg);
                if (id_orgline == -1) {
                    line.setAD_Org_ID(mov.getAD_Org_ID());
                } else {
                    line.setAD_Org_ID(id_orgline);
                }
                line.setM_Inventory_ID(mov.get_ID());
                String sqlst = "SELECT max(m_product_Id) from m_product where value like '" + rs.getString("CODPROD") + "'";
                this.log.config("sql de producto = " + sqlst);
                int ID_Prod = DB.getSQLValue((String)this.get_TrxName(), (String)sqlst);
                this.log.config("codprod " + rs.getString("CODPROD"));
                this.log.config("sql prod = " + ID_Prod);
                line.setM_Product_ID(ID_Prod);
                this.log.config("Cantidad internal use " + rs.getBigDecimal("CANT"));
                this.log.config("Cantidad internal use " + rs.getBigDecimal("CANT").negate());
                String tipomovimiento = rs.getString("TIPOMOV");
                if (tipomovimiento.compareToIgnoreCase("Entrada") == 0) {
                    line.setQtyInternalUse(rs.getBigDecimal("CANT").negate());
                } else if (tipomovimiento.compareToIgnoreCase("Salida") == 0) {
                    line.setQtyInternalUse(rs.getBigDecimal("CANT"));
                }
                int ID_Loc = DB.getSQLValue((String)this.get_TrxName(), (String)(" SELECT MAX(M_Locator_ID) FROM M_Locator  WHERE IsDefault = 'Y' AND M_Warehouse_ID = " + mov.getM_Warehouse_ID()));
                if (ID_Loc <= 0) {
                    ID_Loc = DB.getSQLValue((String)this.get_TrxName(), (String)(" SELECT MAX(M_Locator_ID) FROM M_Locator  WHERE M_Warehouse_ID = " + mov.getM_Warehouse_ID()));
                }
                line.setM_Locator_ID(ID_Loc);
                int ID_Charge = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Charge_ID)  FROM C_Charge cc  INNER JOIN C_ChargeType ct ON (cc.C_ChargeType_ID = ct.C_ChargeType_ID)  WHERE ct.value = 'TCBW'");
                if (ID_Charge <= 0) {
                    ID_Charge = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Charge_ID)  FROM C_Charge cc  WHERE IsActive = 'Y'");
                }
                line.setC_Charge_ID(ID_Charge);
                line.setM_AttributeSetInstance_ID(1059402);
                line.save();
                BigDecimal bdd = new BigDecimal(rs.getString("COSTO"));
                DB.executeUpdate((String)("UPDATE M_Inventoryline set costo = " + bdd + " where m_inventoryline_id = " + line.get_ID()), (String)this.get_TrxName());
                MCostDetail cost = new MCostDetail(this.getCtx(), 0, this.get_TrxName());
                cost.setAmt(bdd);
                if (tipomovimiento.compareToIgnoreCase("Entrada") == 0) {
                    cost.setQty(rs.getBigDecimal("CANT"));
                } else if (tipomovimiento.compareToIgnoreCase("Salida") == 0) {
                    cost.setQty(rs.getBigDecimal("CANT").negate());
                }
                cost.setM_InventoryLine_ID(line.get_ID());
                cost.setM_Product_ID(ID_Prod);
                cost.setDescription("Costo generado por producci\u00f3n v\u00eda WS");
                cost.setC_AcctSchema_ID(1000005);
                cost.save();
                DB.executeUpdate((String)("UPDATE M_Cost set CurrentCostPrice = " + bdd.divide(rs.getBigDecimal("CANT"), 2, RoundingMode.HALF_UP) + " where m_product_id = " + ID_Prod), (String)this.get_TrxName());
                LastMov = mov.get_ID();
                if (rs.getString("I_IMPORTCONSUMPTIONW_ID") != null) {
                    ID_movXML = String.valueOf(ID_movXML) + "," + rs.getString("I_IMPORTCONSUMPTIONW_ID");
                }
                if (rs.getString("I_IMPORTCONSUMPTIONWL_ID") != null) {
                    ID_movXMLLine = String.valueOf(ID_movXMLLine) + "," + rs.getString("I_IMPORTCONSUMPTIONWL_ID");
                }
                String sqlstorage = "SELECT count(1) from m_storage where ad_client_id = 1000005 and m_product_id = " + ID_Prod + " and M_AttributesetInstance_ID = 1059402 and m_locator_id = " + ID_Loc;
                this.log.config("sql storage " + sqlstorage);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return "OK";
    }
}

