/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.part;

import java.util.logging.Level;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Tab;

public class WindowContainer
extends AbstractUIPart {
    private static final int MAX_TITLE_LENGTH = 30;
    private final CLogger log = CLogger.get();
    private Tabbox tabbox;

    public static WindowContainer createFrom(Tabbox tb) {
        WindowContainer wc = new WindowContainer();
        wc.tabbox = tb;
        return wc;
    }

    protected Component doCreatePart(Component parent) {
        this.tabbox = new Tabbox();
        Tabpanels tabpanels = new Tabpanels();
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        this.tabbox.appendChild((Component)tabpanels);
        this.tabbox.setWidth("100%");
        this.tabbox.setHeight("100%");
        if (parent != null) {
            this.tabbox.setParent(parent);
        } else {
            this.tabbox.setPage(this.page);
        }
        return this.tabbox;
    }

    public void addWindow(Component comp, String title, boolean closeable) {
        this.addWindow(comp, title, closeable, true);
    }

    public void addWindow(Component comp, String title, boolean closeable, boolean enable) {
        this.insertBefore(null, comp, title, closeable, enable);
    }

    public void insertBefore(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        org.adempiere.webui.component.Tab tab = new org.adempiere.webui.component.Tab();
        if ((title = title.replaceAll("[&]", "")).length() <= 30) {
            tab.setLabel(title);
        } else {
            tab.setTooltiptext(title);
            title = String.valueOf(title.substring(0, 27)) + "...";
            tab.setLabel(title);
        }
        tab.setClosable(closeable);
        tab.addEventListener("onSelect", new EventListener(){

            public void onEvent(Event event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)event.getTarget();
                org.zkoss.zul.Tabpanel panel = tab.getLinkedPanel();
                Component component = panel.getFirstChild();
                if (component != null && component.getAttribute("TabOnSelectHandler") instanceof ITabOnSelectHandler) {
                    ITabOnSelectHandler handler = (ITabOnSelectHandler)component.getAttribute("TabOnSelectHandler");
                    handler.onSelect();
                }
            }
        });
        Tabpanel tabpanel = null;
        if (comp instanceof Tabpanel) {
            tabpanel = (Tabpanel)comp;
        } else {
            tabpanel = new Tabpanel();
            tabpanel.appendChild(comp);
        }
        this.log.log(Level.SEVERE, "inicio codigo nuevo");
        tabpanel.setZclass("desktop-tabpanel");
        tabpanel.setHeight("100%");
        tabpanel.setWidth("100%");
        tabpanel.setStyle("position: relative;");
        this.log.log(Level.SEVERE, "fin codigo nuevo");
        if (refTab == null) {
            this.tabbox.getTabs().appendChild((Component)tab);
            this.tabbox.getTabpanels().appendChild((Component)tabpanel);
        } else {
            org.zkoss.zul.Tabpanel refpanel = refTab.getLinkedPanel();
            this.tabbox.getTabs().insertBefore((Component)tab, (Component)refTab);
            this.tabbox.getTabpanels().insertBefore((Component)tabpanel, (Component)refpanel);
        }
        if (enable) {
            this.setSelectedTab(tab);
        }
    }

    public void insertAfter(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        if (refTab == null) {
            this.addWindow(comp, title, closeable, enable);
        } else {
            this.insertBefore((org.adempiere.webui.component.Tab)refTab.getNextSibling(), comp, title, closeable, enable);
        }
    }

    public void setSelectedTab(org.adempiere.webui.component.Tab tab) {
        this.tabbox.setSelectedTab((Tab)tab);
    }

    public boolean closeActiveWindow() {
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
        this.tabbox.getSelectedTab().onClose();
        return tab.getParent() == null;
    }

    public org.adempiere.webui.component.Tab getSelectedTab() {
        return (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
    }

    public void setTabTitle(int tabNo, String title, String tooltip) {
        org.zkoss.zul.Tabs tabs = this.tabbox.getTabs();
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)tabs.getChildren().get(tabNo);
        tab.setLabel(title);
        tab.setTooltiptext(tooltip);
    }

    public Tabbox getComponent() {
        return this.tabbox;
    }
}

