/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JScrollPane;
import org.adempiere.apps.graph.Graph;
import org.adempiere.apps.graph.HtmlDashboard;
import org.adempiere.apps.graph.PerformanceDetail;
import org.adempiere.apps.graph.PerformanceIndicator;
import org.compiere.model.MGoal;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PAPanel
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = 4937417260772233929L;
    private MGoal[] m_goals = null;
    private static CLogger log = CLogger.getCLogger(PAPanel.class);

    public static PAPanel get() {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        MGoal[] goals = MGoal.getUserGoals((Properties)Env.getCtx(), (int)AD_User_ID);
        if (goals.length == 0) {
            return null;
        }
        return new PAPanel(goals);
    }

    private PAPanel(MGoal[] goals) {
        this.m_goals = goals;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box boxV = Box.createVerticalBox();
        Box boxH = Box.createHorizontalBox();
        Box boxV1 = Box.createVerticalBox();
        Box boxV2 = Box.createVerticalBox();
        Box boxH1 = Box.createVerticalBox();
        boxV2.setPreferredSize(new Dimension(120, 120));
        int i = 0;
        while (i < this.m_goals.length) {
            PerformanceIndicator pi = new PerformanceIndicator(this.m_goals[i]);
            pi.addActionListener((ActionListener)this);
            boxV1.add((Component)pi, "North");
            ++i;
        }
        boxV1.add(Box.createVerticalGlue(), "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().add((Component)boxV1, "Center");
        scrollPane.setMinimumSize(new Dimension(190, 180));
        String ofb_DashBoard = DB.getSQLValueString(null, (String)"Select Value from AD_SysConfig where name='OFB_TABLE_DASHBOARD'", (Object[])new Object[0]);
        String home = "http:///local/home";
        if (ofb_DashBoard != null && ofb_DashBoard.equals("Y")) {
            home = "http:///local/ofb";
        }
        HtmlDashboard contentHtml = new HtmlDashboard(home, this.m_goals, true);
        boxV2.add((Component)contentHtml, "Center");
        Box boxH1b = Box.createHorizontalBox();
        boxH1b.setAlignmentX(0.0f);
        boxH1b.setAlignmentY(0.0f);
        boxH1.add(boxH1b);
        int i2 = 0;
        while (i2 < Math.min(6, this.m_goals.length)) {
            if (i2 == 3 || i2 == 6) {
                boxH1b = Box.createHorizontalBox();
                boxH1b.setAlignmentX(0.0f);
                boxH1b.setAlignmentY(0.0f);
                boxH1.add(boxH1b);
            }
            if (this.m_goals[i2].getMeasure() != null) {
                Graph g = new Graph(this.m_goals[i2]);
                g.setMaximumSize(new Dimension(330, 280));
                boxH1b.add((Component)g, "Center");
            }
            ++i2;
        }
        boxV2.add((Component)boxH1, "South");
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(30);
        scrollPane2.getViewport().add((Component)boxH1, "North");
        scrollPane2.setMinimumSize(new Dimension(130, 110));
        boxV2.add((Component)scrollPane2, "West");
        boxH.add((Component)scrollPane, "West");
        boxH.add(Box.createHorizontalStrut(5));
        boxH.add((Component)boxV2, "Center");
        HtmlDashboard t = new HtmlDashboard("http:///local/logo", null, false);
        t.setMaximumSize(new Dimension(2000, 80));
        boxV.add((Component)t, "North");
        boxV.add(Box.createVerticalStrut(5));
        boxV.add((Component)boxH, "Center");
        boxV.add(Box.createVerticalGlue());
        this.add(boxV, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof PerformanceIndicator) {
            PerformanceIndicator pi = (PerformanceIndicator)e.getSource();
            log.info(pi.getName());
            MGoal goal = pi.getGoal();
            if (goal.getMeasure() != null) {
                new PerformanceDetail(goal);
            }
        }
    }
}

